<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title>Výpis měření</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis měření</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="SurveyFieldbook">
                                <table class="margin" cellpadding="2" width="80%">
                                    <tbody>
                                        <tr>
                                            <th align="right"  lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Jednotky:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@surveyLinearUnits"/>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                                    <thead style="display:table-header-group">
                                        <tr>
                                            <th class="underline" lang="en" align="left">Název</th>
                                            <th class="underline" lang="en" align="left">Popis</th>
                                            <th class="underline" lang="en" align="left">Definice<br/>prvku</th>
                                            <th class="underline" lang="en" align="left">Kód<br/>propojení</th>
                                            <th class="underline" lang="en" align="right">Zóna</th>
                                            <th class="underline" lang="en" align="left">Vlastnost<br/>terénu</th>
                                            <th class="underline" lang="en" align="left">Dvojice<br/>vlastností</th>
                                            <th class="underline" lang="en" align="left">Řídící<br/>kódy</th>
                                            <th class="underline" lang="en" align="left">Orientace<br/>stroje</th>
                                            <th class="underline" lang="en" align="right">Číslo<br/>sestavy</th>
                                            <th class="underline" lang="en" align="right">Výška<br/>tyče</th>
                                            <th class="underline" lang="en" align="right">Směrový<br/>úhel</th>
                                            <th class="underline" lang="en" align="right">Výškový<br/>úhel</th>
                                            <th class="underline" lang="en" align="right">Šikmá<br/>vzdálenost</th>
                                            <th class="underline" lang="en" align="left">Název<br/>nastavení</th>
                                            <th class="underline" lang="en" align="left">Datový<br/>soubor</th>
                                            <th class="underline" lang="en" align="left">Vba<br/>makro</th>
                                            <th class="underline" lang="en" align="left">Polní<br/>zápisník</th>
                                            <th class="underline" lang="en" align="left">Název<br/>stylu</th>
                                            <th class="underline" lang="en" align="right">Dálkoměrná<br/>lať</th>
                                            <th class="underline" lang="en" align="right">Spodní<br/>lať</th>
                                            <th class="underline" lang="en" align="right">Horní<br/>lať</th>
                                            <th class="underline" lang="en" align="left">Časová<br/>značka</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="SurveyObsList/SurveyObservation">
                                            <tr>

                                                <td align="left">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@code"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@linkCode"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="@zone"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@terrainAttribute"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@attributesPair"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@controlCodes"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@instrumentOrientation"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="@setNumber"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(@rodHeight))"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="cif:angularFormat(number(@horizontalAngle))"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="cif:angularFormat(number(@verticalAngle))"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                                                </td>
                                                <td align="left">
                                                        <xsl:value-of select="@setupName"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@dataFile"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@vbaMacro"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@fieldBook"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@styleName"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="@rodStadia"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="@lowerStadia"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="@upperStadia"/>
                                                </td>
                                                <td align="left">
                                                    <xsl:value-of select="@timeStamp"/>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jedno měření. </p>

      <p class="normal1">
        Pro nejlepší výsledek spusťte výpis z panelu Detaily.   Vyberte Všechna měření v Průzkumníku projektu, které jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
      </p>
      <p class="normal1">
        Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku.
      </p>
      <p class="normal1">Po otevření Průzkumníku výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
      <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
